﻿//////////////////////////////////////////////
// TestRunResult.h
// 
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Forward decl -----------------------------

namespace nkDebug
{
	class TestRunException ;
}

/// Includes ---------------------------------

// nkDebug
#include "../../Dll/DllDefines.h"

#include "TestStackLevel.h"

// nkLog
#include <NilkinsMemory/Containers/BufferCast.h>
#include <NilkinsMemory/Containers/BufferView.h>
#include <NilkinsMemory/Containers/String.h>

/// Class ------------------------------------

namespace nkDebug
{
	class DLL_NKDEBUG_EXPORT TestRunResult final
	{
		public :

			// Functions
			// Constructors
			TestRunResult () noexcept ;
			TestRunResult (const nkMemory::StringView& rejectionReason) noexcept ;
			TestRunResult (const TestRunException& exception) noexcept ;

			// Getters
			nkMemory::StringView getRejectionReason () const ;
			nkMemory::BufferView<TestStackLevel> getRejectionStack () const ;
			bool getSuccess () const ;

			// Operators
			TestRunResult& operator= (const TestRunException& exception) noexcept ;

		private :

			// Attributes
			// Results information
			nkMemory::String _rejectionReason ;
			nkMemory::BufferCast<TestStackLevel> _rejectionStack ;

			bool _success ;
	} ;
}